package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSupportedInstanceTypesRequest(
    releaseLabel: String,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest = {
    import ListSupportedInstanceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest
      .builder()
      .releaseLabel(releaseLabel: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListSupportedInstanceTypesRequest.ReadOnly =
    zio.aws.emr.model.ListSupportedInstanceTypesRequest.wrap(buildAwsValue())
}
object ListSupportedInstanceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListSupportedInstanceTypesRequest =
      zio.aws.emr.model.ListSupportedInstanceTypesRequest(
        releaseLabel,
        marker.map(value => value)
      )
    def releaseLabel: String
    def marker: Optional[String]
    def getReleaseLabel: ZIO[Any, Nothing, String] = ZIO.succeed(releaseLabel)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest
  ) extends zio.aws.emr.model.ListSupportedInstanceTypesRequest.ReadOnly {
    override val releaseLabel: String = impl.releaseLabel(): String
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest
  ): zio.aws.emr.model.ListSupportedInstanceTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
