package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait NotebookExecutionStatus {
  def unwrap: software.amazon.awssdk.services.emr.model.NotebookExecutionStatus
}
object NotebookExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.NotebookExecutionStatus
  ): zio.aws.emr.model.NotebookExecutionStatus = value match {
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.START_PENDING =>
      val r = START_PENDING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FINISHING =>
      val r = FINISHING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FINISHED =>
      val r = FINISHED
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FAILING =>
      val r = FAILING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOP_PENDING =>
      val r = STOP_PENDING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object START_PENDING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.START_PENDING
  }
  case object STARTING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STARTING
  }
  case object RUNNING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.RUNNING
  }
  case object FINISHING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FINISHING
  }
  case object FINISHED extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FINISHED
  }
  case object FAILING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FAILING
  }
  case object FAILED extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.FAILED
  }
  case object STOP_PENDING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOP_PENDING
  }
  case object STOPPING extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOPPING
  }
  case object STOPPED extends zio.aws.emr.model.NotebookExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.NotebookExecutionStatus =
      software.amazon.awssdk.services.emr.model.NotebookExecutionStatus.STOPPED
  }
}
