package zio.aws.emr.model
import zio.aws.emr.model.primitives.{UriString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotebookS3LocationForOutput(
    bucket: Optional[XmlStringMaxLen256] = Optional.Absent,
    key: Optional[UriString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput = {
    import NotebookS3LocationForOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput
      .builder()
      .optionallyWith(
        bucket.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => UriString.unwrap(value): java.lang.String)
      )(_.key)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.NotebookS3LocationForOutput.ReadOnly =
    zio.aws.emr.model.NotebookS3LocationForOutput.wrap(buildAwsValue())
}
object NotebookS3LocationForOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.NotebookS3LocationForOutput =
      zio.aws.emr.model.NotebookS3LocationForOutput(
        bucket.map(value => value),
        key.map(value => value)
      )
    def bucket: Optional[XmlStringMaxLen256]
    def key: Optional[UriString]
    def getBucket: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, UriString] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput
  ) extends zio.aws.emr.model.NotebookS3LocationForOutput.ReadOnly {
    override val bucket: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val key: Optional[UriString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.emr.model.primitives.UriString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput
  ): zio.aws.emr.model.NotebookS3LocationForOutput.ReadOnly = new Wrapper(impl)
}
