package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OSRelease(label: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.OSRelease = {
    import OSRelease.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OSRelease
      .builder()
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.OSRelease.ReadOnly =
    zio.aws.emr.model.OSRelease.wrap(buildAwsValue())
}
object OSRelease {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.OSRelease] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OSRelease =
      zio.aws.emr.model.OSRelease(label.map(value => value))
    def label: Optional[String]
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OSRelease
  ) extends zio.aws.emr.model.OSRelease.ReadOnly {
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OSRelease
  ): zio.aws.emr.model.OSRelease.ReadOnly = new Wrapper(impl)
}
