package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait OnDemandProvisioningAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy
}
object OnDemandProvisioningAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy
  ): zio.aws.emr.model.OnDemandProvisioningAllocationStrategy = value match {
    case software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.LOWEST_PRICE =>
      val r = `lowest-price`
      r
    case software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.PRIORITIZED =>
      val r = prioritized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.OnDemandProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `lowest-price`
      extends zio.aws.emr.model.OnDemandProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.LOWEST_PRICE
  }
  case object prioritized
      extends zio.aws.emr.model.OnDemandProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy.PRIORITIZED
  }
}
