package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.WholeNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OnDemandResizingSpecification(
    timeoutDurationMinutes: Optional[WholeNumber] = Optional.Absent,
    allocationStrategy: Optional[
      zio.aws.emr.model.OnDemandProvisioningAllocationStrategy
    ] = Optional.Absent,
    capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification = {
    import OnDemandResizingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
      .builder()
      .optionallyWith(
        timeoutDurationMinutes.map(value => WholeNumber.unwrap(value): Integer)
      )(_.timeoutDurationMinutes)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(
        capacityReservationOptions.map(value => value.buildAwsValue())
      )(_.capacityReservationOptions)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly =
    zio.aws.emr.model.OnDemandResizingSpecification.wrap(buildAwsValue())
}
object OnDemandResizingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OnDemandResizingSpecification =
      zio.aws.emr.model.OnDemandResizingSpecification(
        timeoutDurationMinutes.map(value => value),
        allocationStrategy.map(value => value),
        capacityReservationOptions.map(value => value.asEditable)
      )
    def timeoutDurationMinutes: Optional[WholeNumber]
    def allocationStrategy
        : Optional[zio.aws.emr.model.OnDemandProvisioningAllocationStrategy]
    def capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ]
    def getTimeoutDurationMinutes: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("timeoutDurationMinutes", timeoutDurationMinutes)
    def getAllocationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandProvisioningAllocationStrategy
    ] = AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getCapacityReservationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationOptions",
      capacityReservationOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ) extends zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly {
    override val timeoutDurationMinutes: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutDurationMinutes())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val allocationStrategy
        : Optional[zio.aws.emr.model.OnDemandProvisioningAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value =>
          zio.aws.emr.model.OnDemandProvisioningAllocationStrategy.wrap(value)
        )
    override val capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationOptions())
      .map(value =>
        zio.aws.emr.model.OnDemandCapacityReservationOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ): zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly = new Wrapper(
    impl
  )
}
