package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PortRange(
    minRange: Port,
    maxRange: Optional[Port] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PortRange
      .builder()
      .minRange(Port.unwrap(minRange): Integer)
      .optionallyWith(maxRange.map(value => Port.unwrap(value): Integer))(
        _.maxRange
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PortRange.ReadOnly =
    zio.aws.emr.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.PortRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PortRange =
      zio.aws.emr.model.PortRange(minRange, maxRange.map(value => value))
    def minRange: Port
    def maxRange: Optional[Port]
    def getMinRange: ZIO[Any, Nothing, Port] = ZIO.succeed(minRange)
    def getMaxRange: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("maxRange", maxRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PortRange
  ) extends zio.aws.emr.model.PortRange.ReadOnly {
    override val minRange: Port =
      zio.aws.emr.model.primitives.Port(impl.minRange())
    override val maxRange: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRange())
      .map(value => zio.aws.emr.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PortRange
  ): zio.aws.emr.model.PortRange.ReadOnly = new Wrapper(impl)
}
