package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, InstanceGroupId, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAutoScalingPolicyResponse(
    clusterId: Optional[ClusterId] = Optional.Absent,
    instanceGroupId: Optional[InstanceGroupId] = Optional.Absent,
    autoScalingPolicy: Optional[
      zio.aws.emr.model.AutoScalingPolicyDescription
    ] = Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse = {
    import PutAutoScalingPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse
      .builder()
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        instanceGroupId.map(value =>
          InstanceGroupId.unwrap(value): java.lang.String
        )
      )(_.instanceGroupId)
      .optionallyWith(autoScalingPolicy.map(value => value.buildAwsValue()))(
        _.autoScalingPolicy
      )
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly =
    zio.aws.emr.model.PutAutoScalingPolicyResponse.wrap(buildAwsValue())
}
object PutAutoScalingPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PutAutoScalingPolicyResponse =
      zio.aws.emr.model.PutAutoScalingPolicyResponse(
        clusterId.map(value => value),
        instanceGroupId.map(value => value),
        autoScalingPolicy.map(value => value.asEditable),
        clusterArn.map(value => value)
      )
    def clusterId: Optional[ClusterId]
    def instanceGroupId: Optional[InstanceGroupId]
    def autoScalingPolicy
        : Optional[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly]
    def clusterArn: Optional[ArnType]
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getInstanceGroupId: ZIO[Any, AwsError, InstanceGroupId] =
      AwsError.unwrapOptionField("instanceGroupId", instanceGroupId)
    def getAutoScalingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField("autoScalingPolicy", autoScalingPolicy)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse
  ) extends zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly {
    override val clusterId: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.emr.model.primitives.ClusterId(value))
    override val instanceGroupId: Optional[InstanceGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroupId())
        .map(value => zio.aws.emr.model.primitives.InstanceGroupId(value))
    override val autoScalingPolicy
        : Optional[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingPolicy())
        .map(value =>
          zio.aws.emr.model.AutoScalingPolicyDescription.wrap(value)
        )
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse
  ): zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly = new Wrapper(impl)
}
