package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutBlockPublicAccessConfigurationRequest(
    blockPublicAccessConfiguration: zio.aws.emr.model.BlockPublicAccessConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest = {
    import PutBlockPublicAccessConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest
      .builder()
      .blockPublicAccessConfiguration(
        blockPublicAccessConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest.ReadOnly =
    zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBlockPublicAccessConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest =
      zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest(
        blockPublicAccessConfiguration.asEditable
      )
    def blockPublicAccessConfiguration
        : zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly
    def getBlockPublicAccessConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly
    ] = ZIO.succeed(blockPublicAccessConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest
  ) extends zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest.ReadOnly {
    override val blockPublicAccessConfiguration
        : zio.aws.emr.model.BlockPublicAccessConfiguration.ReadOnly =
      zio.aws.emr.model.BlockPublicAccessConfiguration
        .wrap(impl.blockPublicAccessConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest
  ): zio.aws.emr.model.PutBlockPublicAccessConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
