package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutManagedScalingPolicyRequest(
    clusterId: ClusterId,
    managedScalingPolicy: zio.aws.emr.model.ManagedScalingPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest = {
    import PutManagedScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .managedScalingPolicy(managedScalingPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PutManagedScalingPolicyRequest.ReadOnly =
    zio.aws.emr.model.PutManagedScalingPolicyRequest.wrap(buildAwsValue())
}
object PutManagedScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PutManagedScalingPolicyRequest =
      zio.aws.emr.model.PutManagedScalingPolicyRequest(
        clusterId,
        managedScalingPolicy.asEditable
      )
    def clusterId: ClusterId
    def managedScalingPolicy: zio.aws.emr.model.ManagedScalingPolicy.ReadOnly
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getManagedScalingPolicy
        : ZIO[Any, Nothing, zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      ZIO.succeed(managedScalingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest
  ) extends zio.aws.emr.model.PutManagedScalingPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val managedScalingPolicy
        : zio.aws.emr.model.ManagedScalingPolicy.ReadOnly =
      zio.aws.emr.model.ManagedScalingPolicy.wrap(impl.managedScalingPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest
  ): zio.aws.emr.model.PutManagedScalingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
