package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ReconfigurationType {
  def unwrap: software.amazon.awssdk.services.emr.model.ReconfigurationType
}
object ReconfigurationType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ReconfigurationType
  ): zio.aws.emr.model.ReconfigurationType = value match {
    case software.amazon.awssdk.services.emr.model.ReconfigurationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ReconfigurationType.OVERWRITE =>
      val r = OVERWRITE
      r
    case software.amazon.awssdk.services.emr.model.ReconfigurationType.MERGE =>
      val r = MERGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.ReconfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ReconfigurationType =
      software.amazon.awssdk.services.emr.model.ReconfigurationType.UNKNOWN_TO_SDK_VERSION
  }
  case object OVERWRITE extends zio.aws.emr.model.ReconfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ReconfigurationType =
      software.amazon.awssdk.services.emr.model.ReconfigurationType.OVERWRITE
  }
  case object MERGE extends zio.aws.emr.model.ReconfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ReconfigurationType =
      software.amazon.awssdk.services.emr.model.ReconfigurationType.MERGE
  }
}
