package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReleaseLabelFilter(
    prefix: Optional[String] = Optional.Absent,
    application: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ReleaseLabelFilter = {
    import ReleaseLabelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(application.map(value => value: java.lang.String))(
        _.application
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ReleaseLabelFilter.ReadOnly =
    zio.aws.emr.model.ReleaseLabelFilter.wrap(buildAwsValue())
}
object ReleaseLabelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ReleaseLabelFilter =
      zio.aws.emr.model.ReleaseLabelFilter(
        prefix.map(value => value),
        application.map(value => value)
      )
    def prefix: Optional[String]
    def application: Optional[String]
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getApplication: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ) extends zio.aws.emr.model.ReleaseLabelFilter.ReadOnly {
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val application: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.application())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ): zio.aws.emr.model.ReleaseLabelFilter.ReadOnly = new Wrapper(impl)
}
