package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceGroupId, ClusterId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveAutoScalingPolicyRequest(
    clusterId: ClusterId,
    instanceGroupId: InstanceGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest = {
    import RemoveAutoScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .instanceGroupId(
        InstanceGroupId.unwrap(instanceGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RemoveAutoScalingPolicyRequest.ReadOnly =
    zio.aws.emr.model.RemoveAutoScalingPolicyRequest.wrap(buildAwsValue())
}
object RemoveAutoScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RemoveAutoScalingPolicyRequest =
      zio.aws.emr.model
        .RemoveAutoScalingPolicyRequest(clusterId, instanceGroupId)
    def clusterId: ClusterId
    def instanceGroupId: InstanceGroupId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getInstanceGroupId: ZIO[Any, Nothing, InstanceGroupId] =
      ZIO.succeed(instanceGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest
  ) extends zio.aws.emr.model.RemoveAutoScalingPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val instanceGroupId: InstanceGroupId =
      zio.aws.emr.model.primitives.InstanceGroupId(impl.instanceGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest
  ): zio.aws.emr.model.RemoveAutoScalingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
