package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveAutoTerminationPolicyRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest = {
    import RemoveAutoTerminationPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.RemoveAutoTerminationPolicyRequest.ReadOnly =
    zio.aws.emr.model.RemoveAutoTerminationPolicyRequest.wrap(buildAwsValue())
}
object RemoveAutoTerminationPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RemoveAutoTerminationPolicyRequest =
      zio.aws.emr.model.RemoveAutoTerminationPolicyRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest
  ) extends zio.aws.emr.model.RemoveAutoTerminationPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest
  ): zio.aws.emr.model.RemoveAutoTerminationPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
