package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunJobFlowResponse(
    jobFlowId: Optional[XmlStringMaxLen256] = Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RunJobFlowResponse = {
    import RunJobFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RunJobFlowResponse
      .builder()
      .optionallyWith(
        jobFlowId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.jobFlowId)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RunJobFlowResponse.ReadOnly =
    zio.aws.emr.model.RunJobFlowResponse.wrap(buildAwsValue())
}
object RunJobFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RunJobFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RunJobFlowResponse =
      zio.aws.emr.model.RunJobFlowResponse(
        jobFlowId.map(value => value),
        clusterArn.map(value => value)
      )
    def jobFlowId: Optional[XmlStringMaxLen256]
    def clusterArn: Optional[ArnType]
    def getJobFlowId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("jobFlowId", jobFlowId)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowResponse
  ) extends zio.aws.emr.model.RunJobFlowResponse.ReadOnly {
    override val jobFlowId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.jobFlowId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowResponse
  ): zio.aws.emr.model.RunJobFlowResponse.ReadOnly = new Wrapper(impl)
}
