package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScalingAction(
    market: Optional[zio.aws.emr.model.MarketType] = Optional.Absent,
    simpleScalingPolicyConfiguration: zio.aws.emr.model.SimpleScalingPolicyConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ScalingAction = {
    import ScalingAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ScalingAction
      .builder()
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .simpleScalingPolicyConfiguration(
        simpleScalingPolicyConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ScalingAction.ReadOnly =
    zio.aws.emr.model.ScalingAction.wrap(buildAwsValue())
}
object ScalingAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ScalingAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ScalingAction =
      zio.aws.emr.model.ScalingAction(
        market.map(value => value),
        simpleScalingPolicyConfiguration.asEditable
      )
    def market: Optional[zio.aws.emr.model.MarketType]
    def simpleScalingPolicyConfiguration
        : zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getSimpleScalingPolicyConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly
    ] = ZIO.succeed(simpleScalingPolicyConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ScalingAction
  ) extends zio.aws.emr.model.ScalingAction.ReadOnly {
    override val market: Optional[zio.aws.emr.model.MarketType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.market())
        .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val simpleScalingPolicyConfiguration
        : zio.aws.emr.model.SimpleScalingPolicyConfiguration.ReadOnly =
      zio.aws.emr.model.SimpleScalingPolicyConfiguration
        .wrap(impl.simpleScalingPolicyConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ScalingAction
  ): zio.aws.emr.model.ScalingAction.ReadOnly = new Wrapper(impl)
}
