package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScalingConstraints(
    minCapacity: Integer,
    maxCapacity: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ScalingConstraints = {
    import ScalingConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ScalingConstraints
      .builder()
      .minCapacity(minCapacity: java.lang.Integer)
      .maxCapacity(maxCapacity: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ScalingConstraints.ReadOnly =
    zio.aws.emr.model.ScalingConstraints.wrap(buildAwsValue())
}
object ScalingConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ScalingConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ScalingConstraints =
      zio.aws.emr.model.ScalingConstraints(minCapacity, maxCapacity)
    def minCapacity: Integer
    def maxCapacity: Integer
    def getMinCapacity: ZIO[Any, Nothing, Integer] = ZIO.succeed(minCapacity)
    def getMaxCapacity: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ScalingConstraints
  ) extends zio.aws.emr.model.ScalingConstraints.ReadOnly {
    override val minCapacity: Integer = impl.minCapacity(): Integer
    override val maxCapacity: Integer = impl.maxCapacity(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ScalingConstraints
  ): zio.aws.emr.model.ScalingConstraints.ReadOnly = new Wrapper(impl)
}
