package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScalingTrigger(
    cloudWatchAlarmDefinition: zio.aws.emr.model.CloudWatchAlarmDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ScalingTrigger = {
    import ScalingTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ScalingTrigger
      .builder()
      .cloudWatchAlarmDefinition(cloudWatchAlarmDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ScalingTrigger.ReadOnly =
    zio.aws.emr.model.ScalingTrigger.wrap(buildAwsValue())
}
object ScalingTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ScalingTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ScalingTrigger =
      zio.aws.emr.model.ScalingTrigger(cloudWatchAlarmDefinition.asEditable)
    def cloudWatchAlarmDefinition
        : zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly
    def getCloudWatchAlarmDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly
    ] = ZIO.succeed(cloudWatchAlarmDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ScalingTrigger
  ) extends zio.aws.emr.model.ScalingTrigger.ReadOnly {
    override val cloudWatchAlarmDefinition
        : zio.aws.emr.model.CloudWatchAlarmDefinition.ReadOnly =
      zio.aws.emr.model.CloudWatchAlarmDefinition
        .wrap(impl.cloudWatchAlarmDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ScalingTrigger
  ): zio.aws.emr.model.ScalingTrigger.ReadOnly = new Wrapper(impl)
}
