package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScriptBootstrapActionConfig(
    path: XmlString,
    args: Optional[Iterable[XmlString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig = {
    import ScriptBootstrapActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig
      .builder()
      .path(XmlString.unwrap(path): java.lang.String)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            XmlString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly =
    zio.aws.emr.model.ScriptBootstrapActionConfig.wrap(buildAwsValue())
}
object ScriptBootstrapActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ScriptBootstrapActionConfig =
      zio.aws.emr.model
        .ScriptBootstrapActionConfig(path, args.map(value => value))
    def path: XmlString
    def args: Optional[List[XmlString]]
    def getPath: ZIO[Any, Nothing, XmlString] = ZIO.succeed(path)
    def getArgs: ZIO[Any, AwsError, List[XmlString]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig
  ) extends zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly {
    override val path: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.path())
    override val args: Optional[List[XmlString]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig
  ): zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly = new Wrapper(impl)
}
