package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlString}
import scala.jdk.CollectionConverters._
final case class SecurityConfigurationSummary(
    name: Optional[XmlString] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary = {
    import SecurityConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary
      .builder()
      .optionallyWith(
        name.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly =
    zio.aws.emr.model.SecurityConfigurationSummary.wrap(buildAwsValue())
}
object SecurityConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SecurityConfigurationSummary =
      zio.aws.emr.model.SecurityConfigurationSummary(
        name.map(value => value),
        creationDateTime.map(value => value)
      )
    def name: Optional[XmlString]
    def creationDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("name", name)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary
  ) extends zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly {
    override val name: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary
  ): zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly = new Wrapper(impl)
}
