package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetKeepJobFlowAliveWhenNoStepsRequest(
    jobFlowIds: Iterable[XmlString],
    keepJobFlowAliveWhenNoSteps: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest = {
    import SetKeepJobFlowAliveWhenNoStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest
      .builder()
      .jobFlowIds(jobFlowIds.map { item =>
        XmlString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .keepJobFlowAliveWhenNoSteps(
        keepJobFlowAliveWhenNoSteps: java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest.ReadOnly =
    zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest
      .wrap(buildAwsValue())
}
object SetKeepJobFlowAliveWhenNoStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest =
      zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest(
        jobFlowIds,
        keepJobFlowAliveWhenNoSteps
      )
    def jobFlowIds: List[XmlString]
    def keepJobFlowAliveWhenNoSteps: Boolean
    def getJobFlowIds: ZIO[Any, Nothing, List[XmlString]] =
      ZIO.succeed(jobFlowIds)
    def getKeepJobFlowAliveWhenNoSteps: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(keepJobFlowAliveWhenNoSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest
  ) extends zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest.ReadOnly {
    override val jobFlowIds: List[XmlString] = impl
      .jobFlowIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlString(item)
      }
      .toList
    override val keepJobFlowAliveWhenNoSteps: Boolean =
      impl.keepJobFlowAliveWhenNoSteps(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest
  ): zio.aws.emr.model.SetKeepJobFlowAliveWhenNoStepsRequest.ReadOnly =
    new Wrapper(impl)
}
