package zio.aws.emr.model
import zio.aws.emr.model.primitives.{BooleanObject, XmlString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetUnhealthyNodeReplacementRequest(
    jobFlowIds: Iterable[XmlString],
    unhealthyNodeReplacement: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SetUnhealthyNodeReplacementRequest = {
    import SetUnhealthyNodeReplacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SetUnhealthyNodeReplacementRequest
      .builder()
      .jobFlowIds(jobFlowIds.map { item =>
        XmlString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .unhealthyNodeReplacement(unhealthyNodeReplacement: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.SetUnhealthyNodeReplacementRequest.ReadOnly =
    zio.aws.emr.model.SetUnhealthyNodeReplacementRequest.wrap(buildAwsValue())
}
object SetUnhealthyNodeReplacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SetUnhealthyNodeReplacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SetUnhealthyNodeReplacementRequest =
      zio.aws.emr.model.SetUnhealthyNodeReplacementRequest(
        jobFlowIds,
        unhealthyNodeReplacement
      )
    def jobFlowIds: List[XmlString]
    def unhealthyNodeReplacement: BooleanObject
    def getJobFlowIds: ZIO[Any, Nothing, List[XmlString]] =
      ZIO.succeed(jobFlowIds)
    def getUnhealthyNodeReplacement: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(unhealthyNodeReplacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SetUnhealthyNodeReplacementRequest
  ) extends zio.aws.emr.model.SetUnhealthyNodeReplacementRequest.ReadOnly {
    override val jobFlowIds: List[XmlString] = impl
      .jobFlowIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlString(item)
      }
      .toList
    override val unhealthyNodeReplacement: BooleanObject =
      impl.unhealthyNodeReplacement(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SetUnhealthyNodeReplacementRequest
  ): zio.aws.emr.model.SetUnhealthyNodeReplacementRequest.ReadOnly =
    new Wrapper(impl)
}
