package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetVisibleToAllUsersRequest(
    jobFlowIds: Iterable[XmlString],
    visibleToAllUsers: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest = {
    import SetVisibleToAllUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest
      .builder()
      .jobFlowIds(jobFlowIds.map { item =>
        XmlString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .visibleToAllUsers(visibleToAllUsers: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SetVisibleToAllUsersRequest.ReadOnly =
    zio.aws.emr.model.SetVisibleToAllUsersRequest.wrap(buildAwsValue())
}
object SetVisibleToAllUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SetVisibleToAllUsersRequest =
      zio.aws.emr.model
        .SetVisibleToAllUsersRequest(jobFlowIds, visibleToAllUsers)
    def jobFlowIds: List[XmlString]
    def visibleToAllUsers: Boolean
    def getJobFlowIds: ZIO[Any, Nothing, List[XmlString]] =
      ZIO.succeed(jobFlowIds)
    def getVisibleToAllUsers: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(visibleToAllUsers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest
  ) extends zio.aws.emr.model.SetVisibleToAllUsersRequest.ReadOnly {
    override val jobFlowIds: List[XmlString] = impl
      .jobFlowIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlString(item)
      }
      .toList
    override val visibleToAllUsers: Boolean = impl.visibleToAllUsers(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest
  ): zio.aws.emr.model.SetVisibleToAllUsersRequest.ReadOnly = new Wrapper(impl)
}
