package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait SpotProvisioningAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy
}
object SpotProvisioningAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy
  ): zio.aws.emr.model.SpotProvisioningAllocationStrategy = value match {
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED =>
      val r = `capacity-optimized`
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.PRICE_CAPACITY_OPTIMIZED =>
      val r = `price-capacity-optimized`
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.LOWEST_PRICE =>
      val r = `lowest-price`
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.DIVERSIFIED =>
      val r = diversified
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED =>
      val r = `capacity-optimized-prioritized`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `capacity-optimized`
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED
  }
  case object `price-capacity-optimized`
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.PRICE_CAPACITY_OPTIMIZED
  }
  case object `lowest-price`
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.LOWEST_PRICE
  }
  case object diversified
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.DIVERSIFIED
  }
  case object `capacity-optimized-prioritized`
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED
  }
}
