package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.WholeNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SpotResizingSpecification(
    timeoutDurationMinutes: Optional[WholeNumber] = Optional.Absent,
    allocationStrategy: Optional[
      zio.aws.emr.model.SpotProvisioningAllocationStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SpotResizingSpecification = {
    import SpotResizingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SpotResizingSpecification
      .builder()
      .optionallyWith(
        timeoutDurationMinutes.map(value => WholeNumber.unwrap(value): Integer)
      )(_.timeoutDurationMinutes)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SpotResizingSpecification.ReadOnly =
    zio.aws.emr.model.SpotResizingSpecification.wrap(buildAwsValue())
}
object SpotResizingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SpotResizingSpecification =
      zio.aws.emr.model.SpotResizingSpecification(
        timeoutDurationMinutes.map(value => value),
        allocationStrategy.map(value => value)
      )
    def timeoutDurationMinutes: Optional[WholeNumber]
    def allocationStrategy
        : Optional[zio.aws.emr.model.SpotProvisioningAllocationStrategy]
    def getTimeoutDurationMinutes: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("timeoutDurationMinutes", timeoutDurationMinutes)
    def getAllocationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.SpotProvisioningAllocationStrategy
    ] = AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ) extends zio.aws.emr.model.SpotResizingSpecification.ReadOnly {
    override val timeoutDurationMinutes: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutDurationMinutes())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val allocationStrategy
        : Optional[zio.aws.emr.model.SpotProvisioningAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value =>
          zio.aws.emr.model.SpotProvisioningAllocationStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ): zio.aws.emr.model.SpotResizingSpecification.ReadOnly = new Wrapper(impl)
}
