package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNotebookExecutionRequest(
    editorId: Optional[XmlStringMaxLen256] = Optional.Absent,
    relativePath: Optional[XmlString] = Optional.Absent,
    notebookExecutionName: Optional[XmlStringMaxLen256] = Optional.Absent,
    notebookParams: Optional[XmlString] = Optional.Absent,
    executionEngine: zio.aws.emr.model.ExecutionEngineConfig,
    serviceRole: XmlString,
    notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.emr.model.Tag]] = Optional.Absent,
    notebookS3Location: Optional[
      zio.aws.emr.model.NotebookS3LocationFromInput
    ] = Optional.Absent,
    outputNotebookS3Location: Optional[
      zio.aws.emr.model.OutputNotebookS3LocationFromInput
    ] = Optional.Absent,
    outputNotebookFormat: Optional[zio.aws.emr.model.OutputNotebookFormat] =
      Optional.Absent,
    environmentVariables: Optional[Map[XmlStringMaxLen256, XmlString]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest = {
    import StartNotebookExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
      .builder()
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(
        relativePath.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.relativePath)
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(
        notebookParams.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.notebookParams)
      .executionEngine(executionEngine.buildAwsValue())
      .serviceRole(XmlString.unwrap(serviceRole): java.lang.String)
      .optionallyWith(
        notebookInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceSecurityGroupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(notebookS3Location.map(value => value.buildAwsValue()))(
        _.notebookS3Location
      )
      .optionallyWith(
        outputNotebookS3Location.map(value => value.buildAwsValue())
      )(_.outputNotebookS3Location)
      .optionallyWith(outputNotebookFormat.map(value => value.unwrap))(
        _.outputNotebookFormat
      )
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (XmlStringMaxLen256.unwrap(key): java.lang.String) -> (XmlString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly =
    zio.aws.emr.model.StartNotebookExecutionRequest.wrap(buildAwsValue())
}
object StartNotebookExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StartNotebookExecutionRequest =
      zio.aws.emr.model.StartNotebookExecutionRequest(
        editorId.map(value => value),
        relativePath.map(value => value),
        notebookExecutionName.map(value => value),
        notebookParams.map(value => value),
        executionEngine.asEditable,
        serviceRole,
        notebookInstanceSecurityGroupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notebookS3Location.map(value => value.asEditable),
        outputNotebookS3Location.map(value => value.asEditable),
        outputNotebookFormat.map(value => value),
        environmentVariables.map(value => value)
      )
    def editorId: Optional[XmlStringMaxLen256]
    def relativePath: Optional[XmlString]
    def notebookExecutionName: Optional[XmlStringMaxLen256]
    def notebookParams: Optional[XmlString]
    def executionEngine: zio.aws.emr.model.ExecutionEngineConfig.ReadOnly
    def serviceRole: XmlString
    def notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256]
    def tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]]
    def notebookS3Location
        : Optional[zio.aws.emr.model.NotebookS3LocationFromInput.ReadOnly]
    def outputNotebookS3Location
        : Optional[zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly]
    def outputNotebookFormat: Optional[zio.aws.emr.model.OutputNotebookFormat]
    def environmentVariables: Optional[Map[XmlStringMaxLen256, XmlString]]
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getRelativePath: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("relativePath", relativePath)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getNotebookParams: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("notebookParams", notebookParams)
    def getExecutionEngine
        : ZIO[Any, Nothing, zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] =
      ZIO.succeed(executionEngine)
    def getServiceRole: ZIO[Any, Nothing, XmlString] = ZIO.succeed(serviceRole)
    def getNotebookInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "notebookInstanceSecurityGroupId",
      notebookInstanceSecurityGroupId
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNotebookS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.NotebookS3LocationFromInput.ReadOnly
    ] = AwsError.unwrapOptionField("notebookS3Location", notebookS3Location)
    def getOutputNotebookS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "outputNotebookS3Location",
      outputNotebookS3Location
    )
    def getOutputNotebookFormat
        : ZIO[Any, AwsError, zio.aws.emr.model.OutputNotebookFormat] =
      AwsError.unwrapOptionField("outputNotebookFormat", outputNotebookFormat)
    def getEnvironmentVariables
        : ZIO[Any, AwsError, Map[XmlStringMaxLen256, XmlString]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ) extends zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly {
    override val editorId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val relativePath: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.relativePath())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val notebookExecutionName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutionName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookParams: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookParams())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val executionEngine
        : zio.aws.emr.model.ExecutionEngineConfig.ReadOnly =
      zio.aws.emr.model.ExecutionEngineConfig.wrap(impl.executionEngine())
    override val serviceRole: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.serviceRole())
    override val notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Tag.wrap(item)
          }.toList
        )
    override val notebookS3Location
        : Optional[zio.aws.emr.model.NotebookS3LocationFromInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookS3Location())
        .map(value => zio.aws.emr.model.NotebookS3LocationFromInput.wrap(value))
    override val outputNotebookS3Location: Optional[
      zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputNotebookS3Location())
      .map(value =>
        zio.aws.emr.model.OutputNotebookS3LocationFromInput.wrap(value)
      )
    override val outputNotebookFormat
        : Optional[zio.aws.emr.model.OutputNotebookFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputNotebookFormat())
        .map(value => zio.aws.emr.model.OutputNotebookFormat.wrap(value))
    override val environmentVariables
        : Optional[Map[XmlStringMaxLen256, XmlString]] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emr.model.primitives.XmlStringMaxLen256(
              key
            ) -> zio.aws.emr.model.primitives.XmlString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest
  ): zio.aws.emr.model.StartNotebookExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
