package zio.aws.emr.model
import zio.aws.emr.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepSummary(
    id: Optional[StepId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    config: Optional[zio.aws.emr.model.HadoopStepConfig] = Optional.Absent,
    actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure] =
      Optional.Absent,
    status: Optional[zio.aws.emr.model.StepStatus] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.StepSummary = {
    import StepSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepSummary
      .builder()
      .optionallyWith(id.map(value => StepId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .optionallyWith(actionOnFailure.map(value => value.unwrap))(
        _.actionOnFailure
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepSummary.ReadOnly =
    zio.aws.emr.model.StepSummary.wrap(buildAwsValue())
}
object StepSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepSummary =
      zio.aws.emr.model.StepSummary(
        id.map(value => value),
        name.map(value => value),
        config.map(value => value.asEditable),
        actionOnFailure.map(value => value),
        status.map(value => value.asEditable)
      )
    def id: Optional[StepId]
    def name: Optional[String]
    def config: Optional[zio.aws.emr.model.HadoopStepConfig.ReadOnly]
    def actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure]
    def status: Optional[zio.aws.emr.model.StepStatus.ReadOnly]
    def getId: ZIO[Any, AwsError, StepId] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfig
        : ZIO[Any, AwsError, zio.aws.emr.model.HadoopStepConfig.ReadOnly] =
      AwsError.unwrapOptionField("config", config)
    def getActionOnFailure
        : ZIO[Any, AwsError, zio.aws.emr.model.ActionOnFailure] =
      AwsError.unwrapOptionField("actionOnFailure", actionOnFailure)
    def getStatus: ZIO[Any, AwsError, zio.aws.emr.model.StepStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepSummary
  ) extends zio.aws.emr.model.StepSummary.ReadOnly {
    override val id: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.StepId(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val config: Optional[zio.aws.emr.model.HadoopStepConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.config())
        .map(value => zio.aws.emr.model.HadoopStepConfig.wrap(value))
    override val actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionOnFailure())
        .map(value => zio.aws.emr.model.ActionOnFailure.wrap(value))
    override val status: Optional[zio.aws.emr.model.StepStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.StepStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepSummary
  ): zio.aws.emr.model.StepSummary.ReadOnly = new Wrapper(impl)
}
