package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  ArnType,
  BooleanObject,
  Date,
  XmlString
}
import scala.jdk.CollectionConverters._
final case class Studio(
    studioId: Optional[XmlStringMaxLen256] = Optional.Absent,
    studioArn: Optional[XmlStringMaxLen256] = Optional.Absent,
    name: Optional[XmlStringMaxLen256] = Optional.Absent,
    description: Optional[XmlStringMaxLen256] = Optional.Absent,
    authMode: Optional[zio.aws.emr.model.AuthMode] = Optional.Absent,
    vpcId: Optional[XmlStringMaxLen256] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    serviceRole: Optional[XmlString] = Optional.Absent,
    userRole: Optional[XmlString] = Optional.Absent,
    workspaceSecurityGroupId: Optional[XmlStringMaxLen256] = Optional.Absent,
    engineSecurityGroupId: Optional[XmlStringMaxLen256] = Optional.Absent,
    url: Optional[XmlString] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    defaultS3Location: Optional[XmlString] = Optional.Absent,
    idpAuthUrl: Optional[XmlString] = Optional.Absent,
    idpRelayStateParameterName: Optional[XmlStringMaxLen256] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.emr.model.Tag]] = Optional.Absent,
    idcInstanceArn: Optional[ArnType] = Optional.Absent,
    trustedIdentityPropagationEnabled: Optional[BooleanObject] =
      Optional.Absent,
    idcUserAssignment: Optional[zio.aws.emr.model.IdcUserAssignment] =
      Optional.Absent,
    encryptionKeyArn: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Studio = {
    import Studio.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Studio
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        studioArn.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioArn)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(
        vpcId.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        serviceRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        userRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.userRole)
      .optionallyWith(
        workspaceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.workspaceSecurityGroupId)
      .optionallyWith(
        engineSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.engineSecurityGroupId)
      .optionallyWith(
        url.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        defaultS3Location.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.defaultS3Location)
      .optionallyWith(
        idpAuthUrl.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.idpAuthUrl)
      .optionallyWith(
        idpRelayStateParameterName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.idpRelayStateParameterName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        idcInstanceArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.idcInstanceArn)
      .optionallyWith(
        trustedIdentityPropagationEnabled.map(value => value: java.lang.Boolean)
      )(_.trustedIdentityPropagationEnabled)
      .optionallyWith(idcUserAssignment.map(value => value.unwrap))(
        _.idcUserAssignment
      )
      .optionallyWith(
        encryptionKeyArn.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Studio.ReadOnly =
    zio.aws.emr.model.Studio.wrap(buildAwsValue())
}
object Studio {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Studio] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Studio = zio.aws.emr.model.Studio(
      studioId.map(value => value),
      studioArn.map(value => value),
      name.map(value => value),
      description.map(value => value),
      authMode.map(value => value),
      vpcId.map(value => value),
      subnetIds.map(value => value),
      serviceRole.map(value => value),
      userRole.map(value => value),
      workspaceSecurityGroupId.map(value => value),
      engineSecurityGroupId.map(value => value),
      url.map(value => value),
      creationTime.map(value => value),
      defaultS3Location.map(value => value),
      idpAuthUrl.map(value => value),
      idpRelayStateParameterName.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      idcInstanceArn.map(value => value),
      trustedIdentityPropagationEnabled.map(value => value),
      idcUserAssignment.map(value => value),
      encryptionKeyArn.map(value => value)
    )
    def studioId: Optional[XmlStringMaxLen256]
    def studioArn: Optional[XmlStringMaxLen256]
    def name: Optional[XmlStringMaxLen256]
    def description: Optional[XmlStringMaxLen256]
    def authMode: Optional[zio.aws.emr.model.AuthMode]
    def vpcId: Optional[XmlStringMaxLen256]
    def subnetIds: Optional[List[String]]
    def serviceRole: Optional[XmlString]
    def userRole: Optional[XmlString]
    def workspaceSecurityGroupId: Optional[XmlStringMaxLen256]
    def engineSecurityGroupId: Optional[XmlStringMaxLen256]
    def url: Optional[XmlString]
    def creationTime: Optional[Date]
    def defaultS3Location: Optional[XmlString]
    def idpAuthUrl: Optional[XmlString]
    def idpRelayStateParameterName: Optional[XmlStringMaxLen256]
    def tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]]
    def idcInstanceArn: Optional[ArnType]
    def trustedIdentityPropagationEnabled: Optional[BooleanObject]
    def idcUserAssignment: Optional[zio.aws.emr.model.IdcUserAssignment]
    def encryptionKeyArn: Optional[XmlString]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getStudioArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioArn", studioArn)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.emr.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getVpcId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getServiceRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getUserRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("userRole", userRole)
    def getWorkspaceSecurityGroupId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "workspaceSecurityGroupId",
        workspaceSecurityGroupId
      )
    def getEngineSecurityGroupId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("engineSecurityGroupId", engineSecurityGroupId)
    def getUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("url", url)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultS3Location: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("defaultS3Location", defaultS3Location)
    def getIdpAuthUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("idpAuthUrl", idpAuthUrl)
    def getIdpRelayStateParameterName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "idpRelayStateParameterName",
        idpRelayStateParameterName
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIdcInstanceArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("idcInstanceArn", idcInstanceArn)
    def getTrustedIdentityPropagationEnabled
        : ZIO[Any, AwsError, BooleanObject] = AwsError.unwrapOptionField(
      "trustedIdentityPropagationEnabled",
      trustedIdentityPropagationEnabled
    )
    def getIdcUserAssignment
        : ZIO[Any, AwsError, zio.aws.emr.model.IdcUserAssignment] =
      AwsError.unwrapOptionField("idcUserAssignment", idcUserAssignment)
    def getEncryptionKeyArn: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Studio
  ) extends zio.aws.emr.model.Studio.ReadOnly {
    override val studioId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val studioArn: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioArn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val name: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val description: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val authMode: Optional[zio.aws.emr.model.AuthMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authMode())
        .map(value => zio.aws.emr.model.AuthMode.wrap(value))
    override val vpcId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val userRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.userRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val workspaceSecurityGroupId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val engineSecurityGroupId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val url: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val defaultS3Location: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultS3Location())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val idpAuthUrl: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.idpAuthUrl())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val idpRelayStateParameterName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idpRelayStateParameterName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Tag.wrap(item)
          }.toList
        )
    override val idcInstanceArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.idcInstanceArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
    override val trustedIdentityPropagationEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustedIdentityPropagationEnabled())
        .map(value => value: BooleanObject)
    override val idcUserAssignment
        : Optional[zio.aws.emr.model.IdcUserAssignment] = zio.aws.core.internal
      .optionalFromNullable(impl.idcUserAssignment())
      .map(value => zio.aws.emr.model.IdcUserAssignment.wrap(value))
    override val encryptionKeyArn: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKeyArn())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Studio
  ): zio.aws.emr.model.Studio.ReadOnly = new Wrapper(impl)
}
