package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import scala.jdk.CollectionConverters._
final case class StudioSummary(
    studioId: Optional[XmlStringMaxLen256] = Optional.Absent,
    name: Optional[XmlStringMaxLen256] = Optional.Absent,
    vpcId: Optional[XmlStringMaxLen256] = Optional.Absent,
    description: Optional[XmlStringMaxLen256] = Optional.Absent,
    url: Optional[XmlStringMaxLen256] = Optional.Absent,
    authMode: Optional[zio.aws.emr.model.AuthMode] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StudioSummary = {
    import StudioSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StudioSummary
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        vpcId.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        url.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StudioSummary.ReadOnly =
    zio.aws.emr.model.StudioSummary.wrap(buildAwsValue())
}
object StudioSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StudioSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StudioSummary =
      zio.aws.emr.model.StudioSummary(
        studioId.map(value => value),
        name.map(value => value),
        vpcId.map(value => value),
        description.map(value => value),
        url.map(value => value),
        authMode.map(value => value),
        creationTime.map(value => value)
      )
    def studioId: Optional[XmlStringMaxLen256]
    def name: Optional[XmlStringMaxLen256]
    def vpcId: Optional[XmlStringMaxLen256]
    def description: Optional[XmlStringMaxLen256]
    def url: Optional[XmlStringMaxLen256]
    def authMode: Optional[zio.aws.emr.model.AuthMode]
    def creationTime: Optional[Date]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getVpcId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getUrl: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("url", url)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.emr.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StudioSummary
  ) extends zio.aws.emr.model.StudioSummary.ReadOnly {
    override val studioId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val name: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val vpcId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val description: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val url: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val authMode: Optional[zio.aws.emr.model.AuthMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authMode())
        .map(value => zio.aws.emr.model.AuthMode.wrap(value))
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StudioSummary
  ): zio.aws.emr.model.StudioSummary.ReadOnly = new Wrapper(impl)
}
