package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SupportedInstanceType(
    `type`: Optional[String] = Optional.Absent,
    memoryGB: Optional[Float] = Optional.Absent,
    storageGB: Optional[Integer] = Optional.Absent,
    vcpu: Optional[Integer] = Optional.Absent,
    is64BitsOnly: Optional[Boolean] = Optional.Absent,
    instanceFamilyId: Optional[String] = Optional.Absent,
    ebsOptimizedAvailable: Optional[Boolean] = Optional.Absent,
    ebsOptimizedByDefault: Optional[Boolean] = Optional.Absent,
    numberOfDisks: Optional[Integer] = Optional.Absent,
    ebsStorageOnly: Optional[Boolean] = Optional.Absent,
    architecture: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SupportedInstanceType = {
    import SupportedInstanceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SupportedInstanceType
      .builder()
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(memoryGB.map(value => value: java.lang.Float))(_.memoryGB)
      .optionallyWith(storageGB.map(value => value: java.lang.Integer))(
        _.storageGB
      )
      .optionallyWith(vcpu.map(value => value: java.lang.Integer))(_.vcpu)
      .optionallyWith(is64BitsOnly.map(value => value: java.lang.Boolean))(
        _.is64BitsOnly
      )
      .optionallyWith(instanceFamilyId.map(value => value: java.lang.String))(
        _.instanceFamilyId
      )
      .optionallyWith(
        ebsOptimizedAvailable.map(value => value: java.lang.Boolean)
      )(_.ebsOptimizedAvailable)
      .optionallyWith(
        ebsOptimizedByDefault.map(value => value: java.lang.Boolean)
      )(_.ebsOptimizedByDefault)
      .optionallyWith(numberOfDisks.map(value => value: java.lang.Integer))(
        _.numberOfDisks
      )
      .optionallyWith(ebsStorageOnly.map(value => value: java.lang.Boolean))(
        _.ebsStorageOnly
      )
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SupportedInstanceType.ReadOnly =
    zio.aws.emr.model.SupportedInstanceType.wrap(buildAwsValue())
}
object SupportedInstanceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SupportedInstanceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SupportedInstanceType =
      zio.aws.emr.model.SupportedInstanceType(
        `type`.map(value => value),
        memoryGB.map(value => value),
        storageGB.map(value => value),
        vcpu.map(value => value),
        is64BitsOnly.map(value => value),
        instanceFamilyId.map(value => value),
        ebsOptimizedAvailable.map(value => value),
        ebsOptimizedByDefault.map(value => value),
        numberOfDisks.map(value => value),
        ebsStorageOnly.map(value => value),
        architecture.map(value => value)
      )
    def `type`: Optional[String]
    def memoryGB: Optional[Float]
    def storageGB: Optional[Integer]
    def vcpu: Optional[Integer]
    def is64BitsOnly: Optional[Boolean]
    def instanceFamilyId: Optional[String]
    def ebsOptimizedAvailable: Optional[Boolean]
    def ebsOptimizedByDefault: Optional[Boolean]
    def numberOfDisks: Optional[Integer]
    def ebsStorageOnly: Optional[Boolean]
    def architecture: Optional[String]
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getMemoryGB: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("memoryGB", memoryGB)
    def getStorageGB: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("storageGB", storageGB)
    def getVcpu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vcpu", vcpu)
    def getIs64BitsOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("is64BitsOnly", is64BitsOnly)
    def getInstanceFamilyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamilyId", instanceFamilyId)
    def getEbsOptimizedAvailable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimizedAvailable", ebsOptimizedAvailable)
    def getEbsOptimizedByDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimizedByDefault", ebsOptimizedByDefault)
    def getNumberOfDisks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfDisks", numberOfDisks)
    def getEbsStorageOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsStorageOnly", ebsStorageOnly)
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SupportedInstanceType
  ) extends zio.aws.emr.model.SupportedInstanceType.ReadOnly {
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val memoryGB: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryGB())
      .map(value => value: Float)
    override val storageGB: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.storageGB())
      .map(value => value: Integer)
    override val vcpu: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vcpu())
      .map(value => value: Integer)
    override val is64BitsOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.is64BitsOnly())
      .map(value => value: Boolean)
    override val instanceFamilyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamilyId())
      .map(value => value: String)
    override val ebsOptimizedAvailable: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptimizedAvailable())
        .map(value => value: Boolean)
    override val ebsOptimizedByDefault: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptimizedByDefault())
        .map(value => value: Boolean)
    override val numberOfDisks: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfDisks())
      .map(value => value: Integer)
    override val ebsStorageOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsStorageOnly())
      .map(value => value: Boolean)
    override val architecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SupportedInstanceType
  ): zio.aws.emr.model.SupportedInstanceType.ReadOnly = new Wrapper(impl)
}
