package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UsernamePassword(
    username: Optional[XmlStringMaxLen256] = Optional.Absent,
    password: Optional[XmlStringMaxLen256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.UsernamePassword = {
    import UsernamePassword.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.UsernamePassword
      .builder()
      .optionallyWith(
        username.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.username)
      .optionallyWith(
        password.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.password)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.UsernamePassword.ReadOnly =
    zio.aws.emr.model.UsernamePassword.wrap(buildAwsValue())
}
object UsernamePassword {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.UsernamePassword
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.UsernamePassword =
      zio.aws.emr.model.UsernamePassword(
        username.map(value => value),
        password.map(value => value)
      )
    def username: Optional[XmlStringMaxLen256]
    def password: Optional[XmlStringMaxLen256]
    def getUsername: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("password", password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.UsernamePassword
  ) extends zio.aws.emr.model.UsernamePassword.ReadOnly {
    override val username: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val password: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.UsernamePassword
  ): zio.aws.emr.model.UsernamePassword.ReadOnly = new Wrapper(impl)
}
