package zio.aws.emr
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256, InstanceId}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.emr.model.primitives.Marker.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ArnType extends zio.prelude.Subtype[String]
    type ArnType = zio.aws.emr.model.primitives.ArnType.Type
    type BooleanObject = Boolean
    object ClusterId extends zio.prelude.Subtype[String]
    type ClusterId = zio.aws.emr.model.primitives.ClusterId.Type
    object Date extends zio.prelude.Subtype[Instant]
    type Date = zio.aws.emr.model.primitives.Date.Type
    object IAMRoleArn extends zio.prelude.Subtype[String]
    type IAMRoleArn = zio.aws.emr.model.primitives.IAMRoleArn.Type
    object InstanceFleetId extends zio.prelude.Subtype[String]
    type InstanceFleetId = zio.aws.emr.model.primitives.InstanceFleetId.Type
    object InstanceGroupId extends zio.prelude.Subtype[String]
    type InstanceGroupId = zio.aws.emr.model.primitives.InstanceGroupId.Type
    object InstanceId extends zio.prelude.Subtype[String]
    type InstanceId = zio.aws.emr.model.primitives.InstanceId.Type
    object InstanceType extends zio.prelude.Subtype[String]
    type InstanceType = zio.aws.emr.model.primitives.InstanceType.Type
    type Integer = Int
    object Marker extends zio.prelude.Subtype[String]
    type Marker = zio.aws.emr.model.primitives.Marker.Type
    object MaxResultsNumber extends zio.prelude.Subtype[Int]
    type MaxResultsNumber = zio.aws.emr.model.primitives.MaxResultsNumber.Type
    object NonNegativeDouble extends zio.prelude.Subtype[Double]
    type NonNegativeDouble = zio.aws.emr.model.primitives.NonNegativeDouble.Type
    object OptionalArnType extends zio.prelude.Subtype[String]
    type OptionalArnType = zio.aws.emr.model.primitives.OptionalArnType.Type
    object Port extends zio.prelude.Subtype[Int]
    type Port = zio.aws.emr.model.primitives.Port.Type
    object ResourceId extends zio.prelude.Subtype[String]
    type ResourceId = zio.aws.emr.model.primitives.ResourceId.Type
    object StepId extends zio.prelude.Subtype[String]
    type StepId = zio.aws.emr.model.primitives.StepId.Type
    object ThroughputVal extends zio.prelude.Subtype[Int]
    type ThroughputVal = zio.aws.emr.model.primitives.ThroughputVal.Type
    object UriString extends zio.prelude.Subtype[String]
    type UriString = zio.aws.emr.model.primitives.UriString.Type
    object WholeNumber extends zio.prelude.Subtype[Int]
    type WholeNumber = zio.aws.emr.model.primitives.WholeNumber.Type
    object XmlString extends zio.prelude.Subtype[String]
    type XmlString = zio.aws.emr.model.primitives.XmlString.Type
    object XmlStringMaxLen256 extends zio.prelude.Subtype[String]
    type XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256.Type
  }
  type ApplicationList = List[zio.aws.emr.model.Application]
  type BootstrapActionConfigList = List[zio.aws.emr.model.BootstrapActionConfig]
  type CancelStepsInfoList = List[zio.aws.emr.model.CancelStepsInfo]
  type ClusterStateList = List[zio.aws.emr.model.ClusterState]
  type ClusterSummaryList = List[zio.aws.emr.model.ClusterSummary]
  type CommandList = List[zio.aws.emr.model.Command]
  type ConfigurationList = List[zio.aws.emr.model.Configuration]
  type EC2InstanceIdsList = List[InstanceId]
  type EC2InstanceIdsToTerminateList = List[InstanceId]
  type EbsBlockDeviceConfigList = List[zio.aws.emr.model.EbsBlockDeviceConfig]
  type EbsBlockDeviceList = List[zio.aws.emr.model.EbsBlockDevice]
  type EbsVolumeList = List[zio.aws.emr.model.EbsVolume]
  type EnvironmentVariablesMap = Map[XmlStringMaxLen256, XmlString]
  type ErrorData = List[Map[String, String]]
  type ErrorDetailList = List[zio.aws.emr.model.ErrorDetail]
  type InstanceFleetConfigList = List[zio.aws.emr.model.InstanceFleetConfig]
  type InstanceFleetList = List[zio.aws.emr.model.InstanceFleet]
  type InstanceGroupConfigList = List[zio.aws.emr.model.InstanceGroupConfig]
  type InstanceGroupIdsList = List[XmlStringMaxLen256]
  type InstanceGroupList = List[zio.aws.emr.model.InstanceGroup]
  type InstanceGroupModifyConfigList =
    List[zio.aws.emr.model.InstanceGroupModifyConfig]
  type InstanceGroupTypeList = List[zio.aws.emr.model.InstanceGroupType]
  type InstanceList = List[zio.aws.emr.model.Instance]
  type InstanceStateList = List[zio.aws.emr.model.InstanceState]
  type InstanceTypeConfigList = List[zio.aws.emr.model.InstanceTypeConfig]
  type InstanceTypeSpecificationList =
    List[zio.aws.emr.model.InstanceTypeSpecification]
  type KeyValueList = List[zio.aws.emr.model.KeyValue]
  type MetricDimensionList = List[zio.aws.emr.model.MetricDimension]
  type NewSupportedProductsList = List[zio.aws.emr.model.SupportedProductConfig]
  type NotebookExecutionSummaryList =
    List[zio.aws.emr.model.NotebookExecutionSummary]
  type OSReleaseList = List[zio.aws.emr.model.OSRelease]
  type PlacementGroupConfigList = List[zio.aws.emr.model.PlacementGroupConfig]
  type PortRanges = List[zio.aws.emr.model.PortRange]
  type ScalingRuleList = List[zio.aws.emr.model.ScalingRule]
  type SecurityConfigurationList =
    List[zio.aws.emr.model.SecurityConfigurationSummary]
  type SecurityGroupsList = List[XmlStringMaxLen256]
  type SessionMappingSummaryList = List[zio.aws.emr.model.SessionMappingSummary]
  type SimplifiedApplicationList = List[zio.aws.emr.model.SimplifiedApplication]
  type StepConfigList = List[zio.aws.emr.model.StepConfig]
  type StepIdsList = List[XmlStringMaxLen256]
  type StepStateList = List[zio.aws.emr.model.StepState]
  type StepSummaryList = List[zio.aws.emr.model.StepSummary]
  type StringList = List[String]
  type StringMap = Map[String, String]
  type StudioSummaryList = List[zio.aws.emr.model.StudioSummary]
  type SubnetIdList = List[String]
  type SupportedInstanceTypesList =
    List[zio.aws.emr.model.SupportedInstanceType]
  type SupportedProductsList = List[XmlStringMaxLen256]
  type TagList = List[zio.aws.emr.model.Tag]
  type XmlStringList = List[XmlString]
  type XmlStringMaxLen256List = List[XmlStringMaxLen256]
}
