package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait ArchiveState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ArchiveState
}
object ArchiveState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ArchiveState
  ): zio.aws.eventbridge.model.ArchiveState = value match {
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.eventbridge.model.ArchiveState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.ENABLED
  }
  case object DISABLED extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.DISABLED
  }
  case object CREATING extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.CREATING
  }
  case object UPDATING extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.UPDATING
  }
  case object CREATE_FAILED extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.eventbridge.model.ArchiveState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ArchiveState =
      software.amazon.awssdk.services.eventbridge.model.ArchiveState.UPDATE_FAILED
  }
}
