package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  IamRoleArn,
  EndpointArn,
  EndpointName
}
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(
    name: Optional[EndpointName] = Optional.Absent,
    arn: Optional[EndpointArn] = Optional.Absent,
    routingConfig: Optional[zio.aws.eventbridge.model.RoutingConfig] =
      Optional.Absent,
    replicationConfig: Optional[zio.aws.eventbridge.model.ReplicationConfig] =
      Optional.Absent,
    eventBuses: Optional[Iterable[zio.aws.eventbridge.model.EndpointEventBus]] =
      Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.EndpointState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse
      .builder()
      .optionallyWith(
        name.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => EndpointArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .optionallyWith(
        eventBuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventBuses)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly =
    zio.aws.eventbridge.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateEndpointResponse =
      zio.aws.eventbridge.model.CreateEndpointResponse(
        name.map(value => value),
        arn.map(value => value),
        routingConfig.map(value => value.asEditable),
        replicationConfig.map(value => value.asEditable),
        eventBuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value),
        state.map(value => value)
      )
    def name: Optional[EndpointName]
    def arn: Optional[EndpointArn]
    def routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly]
    def replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly]
    def eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]]
    def roleArn: Optional[IamRoleArn]
    def state: Optional[zio.aws.eventbridge.model.EndpointState]
    def getName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, EndpointArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getRoutingConfig
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
    def getEventBuses: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.EndpointEventBus.ReadOnly
    ]] = AwsError.unwrapOptionField("eventBuses", eventBuses)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.EndpointState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse
  ) extends zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly {
    override val name: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointName(value))
    override val arn: Optional[EndpointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointArn(value))
    override val routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value => zio.aws.eventbridge.model.RoutingConfig.wrap(value))
    override val replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value => zio.aws.eventbridge.model.ReplicationConfig.wrap(value))
    override val eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.EndpointEventBus.wrap(item)
          }.toList
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.IamRoleArn(value))
    override val state: Optional[zio.aws.eventbridge.model.EndpointState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.EndpointState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse
  ): zio.aws.eventbridge.model.CreateEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
