package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  IamRoleArn,
  EndpointName,
  EndpointUrl,
  Timestamp,
  EndpointStateReason,
  EndpointArn,
  EndpointDescription,
  EndpointId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointResponse(
    name: Optional[EndpointName] = Optional.Absent,
    description: Optional[EndpointDescription] = Optional.Absent,
    arn: Optional[EndpointArn] = Optional.Absent,
    routingConfig: Optional[zio.aws.eventbridge.model.RoutingConfig] =
      Optional.Absent,
    replicationConfig: Optional[zio.aws.eventbridge.model.ReplicationConfig] =
      Optional.Absent,
    eventBuses: Optional[Iterable[zio.aws.eventbridge.model.EndpointEventBus]] =
      Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    endpointId: Optional[EndpointId] = Optional.Absent,
    endpointUrl: Optional[EndpointUrl] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.EndpointState] = Optional.Absent,
    stateReason: Optional[EndpointStateReason] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse = {
    import DescribeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse
      .builder()
      .optionallyWith(
        name.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          EndpointDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        arn.map(value => EndpointArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .optionallyWith(
        eventBuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventBuses)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        endpointId.map(value => EndpointId.unwrap(value): java.lang.String)
      )(_.endpointId)
      .optionallyWith(
        endpointUrl.map(value => EndpointUrl.unwrap(value): java.lang.String)
      )(_.endpointUrl)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          EndpointStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeEndpointResponse.wrap(buildAwsValue())
}
object DescribeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEndpointResponse =
      zio.aws.eventbridge.model.DescribeEndpointResponse(
        name.map(value => value),
        description.map(value => value),
        arn.map(value => value),
        routingConfig.map(value => value.asEditable),
        replicationConfig.map(value => value.asEditable),
        eventBuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value),
        endpointId.map(value => value),
        endpointUrl.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def name: Optional[EndpointName]
    def description: Optional[EndpointDescription]
    def arn: Optional[EndpointArn]
    def routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly]
    def replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly]
    def eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]]
    def roleArn: Optional[IamRoleArn]
    def endpointId: Optional[EndpointId]
    def endpointUrl: Optional[EndpointUrl]
    def state: Optional[zio.aws.eventbridge.model.EndpointState]
    def stateReason: Optional[EndpointStateReason]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, EndpointDescription] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, EndpointArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getRoutingConfig
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
    def getEventBuses: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.EndpointEventBus.ReadOnly
    ]] = AwsError.unwrapOptionField("eventBuses", eventBuses)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEndpointId: ZIO[Any, AwsError, EndpointId] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getEndpointUrl: ZIO[Any, AwsError, EndpointUrl] =
      AwsError.unwrapOptionField("endpointUrl", endpointUrl)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.EndpointState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, EndpointStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse
  ) extends zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly {
    override val name: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointName(value))
    override val description: Optional[EndpointDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EndpointDescription(value)
        )
    override val arn: Optional[EndpointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointArn(value))
    override val routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value => zio.aws.eventbridge.model.RoutingConfig.wrap(value))
    override val replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value => zio.aws.eventbridge.model.ReplicationConfig.wrap(value))
    override val eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.EndpointEventBus.wrap(item)
          }.toList
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.IamRoleArn(value))
    override val endpointId: Optional[EndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointId(value))
    override val endpointUrl: Optional[EndpointUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointUrl())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointUrl(value))
    override val state: Optional[zio.aws.eventbridge.model.EndpointState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.EndpointState.wrap(value))
    override val stateReason: Optional[EndpointStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EndpointStateReason(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse
  ): zio.aws.eventbridge.model.DescribeEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
