package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePartnerEventSourceResponse(
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse = {
    import DescribePartnerEventSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribePartnerEventSourceResponse
      .wrap(buildAwsValue())
}
object DescribePartnerEventSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.DescribePartnerEventSourceResponse =
      zio.aws.eventbridge.model.DescribePartnerEventSourceResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[String]
    def name: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse
  ) extends zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse
  ): zio.aws.eventbridge.model.DescribePartnerEventSourceResponse.ReadOnly =
    new Wrapper(impl)
}
