package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.TargetPartitionKeyPath
import scala.jdk.CollectionConverters.*
final case class KinesisParameters(partitionKeyPath: TargetPartitionKeyPath) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.KinesisParameters = {
    import KinesisParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.KinesisParameters
      .builder()
      .partitionKeyPath(
        TargetPartitionKeyPath.unwrap(partitionKeyPath): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.KinesisParameters.ReadOnly =
    zio.aws.eventbridge.model.KinesisParameters.wrap(buildAwsValue())
}
object KinesisParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.KinesisParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.KinesisParameters =
      zio.aws.eventbridge.model.KinesisParameters(partitionKeyPath)
    def partitionKeyPath: TargetPartitionKeyPath
    def getPartitionKeyPath: ZIO[Any, Nothing, TargetPartitionKeyPath] =
      ZIO.succeed(partitionKeyPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.KinesisParameters
  ) extends zio.aws.eventbridge.model.KinesisParameters.ReadOnly {
    override val partitionKeyPath: TargetPartitionKeyPath =
      zio.aws.eventbridge.model.primitives
        .TargetPartitionKeyPath(impl.partitionKeyPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.KinesisParameters
  ): zio.aws.eventbridge.model.KinesisParameters.ReadOnly = new Wrapper(impl)
}
