package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchType {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.LaunchType
}
object LaunchType {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.LaunchType
  ): zio.aws.eventbridge.model.LaunchType = value match {
    case software.amazon.awssdk.services.eventbridge.model.LaunchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.LaunchType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.eventbridge.model.LaunchType.FARGATE =>
      val r = FARGATE
      r
    case software.amazon.awssdk.services.eventbridge.model.LaunchType.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.eventbridge.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.LaunchType =
      software.amazon.awssdk.services.eventbridge.model.LaunchType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.eventbridge.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.LaunchType =
      software.amazon.awssdk.services.eventbridge.model.LaunchType.EC2
  }
  case object FARGATE extends zio.aws.eventbridge.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.LaunchType =
      software.amazon.awssdk.services.eventbridge.model.LaunchType.FARGATE
  }
  case object EXTERNAL extends zio.aws.eventbridge.model.LaunchType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.LaunchType =
      software.amazon.awssdk.services.eventbridge.model.LaunchType.EXTERNAL
  }
}
