package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  HomeRegion,
  EndpointName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEndpointsRequest(
    namePrefix: Optional[EndpointName] = Optional.Absent,
    homeRegion: Optional[HomeRegion] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest = {
    import ListEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        homeRegion.map(value => HomeRegion.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => LimitMax100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListEndpointsRequest.ReadOnly =
    zio.aws.eventbridge.model.ListEndpointsRequest.wrap(buildAwsValue())
}
object ListEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListEndpointsRequest =
      zio.aws.eventbridge.model.ListEndpointsRequest(
        namePrefix.map(value => value),
        homeRegion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def namePrefix: Optional[EndpointName]
    def homeRegion: Optional[HomeRegion]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getHomeRegion: ZIO[Any, AwsError, HomeRegion] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest
  ) extends zio.aws.eventbridge.model.ListEndpointsRequest.ReadOnly {
    override val namePrefix: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointName(value))
    override val homeRegion: Optional[HomeRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.homeRegion())
      .map(value => zio.aws.eventbridge.model.primitives.HomeRegion(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val maxResults: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest
  ): zio.aws.eventbridge.model.ListEndpointsRequest.ReadOnly = new Wrapper(impl)
}
