package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEndpointsResponse(
    endpoints: Optional[Iterable[zio.aws.eventbridge.model.Endpoint]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse = {
    import ListEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse
      .builder()
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly =
    zio.aws.eventbridge.model.ListEndpointsResponse.wrap(buildAwsValue())
}
object ListEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListEndpointsResponse =
      zio.aws.eventbridge.model.ListEndpointsResponse(
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpoints: Optional[List[zio.aws.eventbridge.model.Endpoint.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.Endpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse
  ) extends zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly {
    override val endpoints
        : Optional[List[zio.aws.eventbridge.model.Endpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Endpoint.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse
  ): zio.aws.eventbridge.model.ListEndpointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
