package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  PartnerEventSourceNamePrefix
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPartnerEventSourcesRequest(
    namePrefix: PartnerEventSourceNamePrefix,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest = {
    import ListPartnerEventSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest
      .builder()
      .namePrefix(
        PartnerEventSourceNamePrefix.unwrap(namePrefix): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListPartnerEventSourcesRequest.ReadOnly =
    zio.aws.eventbridge.model.ListPartnerEventSourcesRequest
      .wrap(buildAwsValue())
}
object ListPartnerEventSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListPartnerEventSourcesRequest =
      zio.aws.eventbridge.model.ListPartnerEventSourcesRequest(
        namePrefix,
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: PartnerEventSourceNamePrefix
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, Nothing, PartnerEventSourceNamePrefix] =
      ZIO.succeed(namePrefix)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest
  ) extends zio.aws.eventbridge.model.ListPartnerEventSourcesRequest.ReadOnly {
    override val namePrefix: PartnerEventSourceNamePrefix =
      zio.aws.eventbridge.model.primitives
        .PartnerEventSourceNamePrefix(impl.namePrefix())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest
  ): zio.aws.eventbridge.model.ListPartnerEventSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
