package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  LimitMax100,
  NextToken,
  Arn,
  ReplayName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListReplaysRequest(
    namePrefix: Optional[ReplayName] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ReplayState] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    limit: Optional[LimitMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest = {
    import ListReplaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest
      .builder()
      .optionallyWith(
        namePrefix.map(value => ReplayName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(limit.map(value => LimitMax100.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListReplaysRequest.ReadOnly =
    zio.aws.eventbridge.model.ListReplaysRequest.wrap(buildAwsValue())
}
object ListReplaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListReplaysRequest =
      zio.aws.eventbridge.model.ListReplaysRequest(
        namePrefix.map(value => value),
        state.map(value => value),
        eventSourceArn.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def namePrefix: Optional[ReplayName]
    def state: Optional[zio.aws.eventbridge.model.ReplayState]
    def eventSourceArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def limit: Optional[LimitMax100]
    def getNamePrefix: ZIO[Any, AwsError, ReplayName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplayState] =
      AwsError.unwrapOptionField("state", state)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, LimitMax100] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest
  ) extends zio.aws.eventbridge.model.ListReplaysRequest.ReadOnly {
    override val namePrefix: Optional[ReplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.namePrefix())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayName(value))
    override val state: Optional[zio.aws.eventbridge.model.ReplayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplayState.wrap(value))
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.eventbridge.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
    override val limit: Optional[LimitMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.eventbridge.model.primitives.LimitMax100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest
  ): zio.aws.eventbridge.model.ListReplaysRequest.ReadOnly = new Wrapper(impl)
}
