package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListReplaysResponse(
    replays: Optional[Iterable[zio.aws.eventbridge.model.Replay]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse = {
    import ListReplaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse
      .builder()
      .optionallyWith(
        replays.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replays)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly =
    zio.aws.eventbridge.model.ListReplaysResponse.wrap(buildAwsValue())
}
object ListReplaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListReplaysResponse =
      zio.aws.eventbridge.model.ListReplaysResponse(
        replays.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def replays: Optional[List[zio.aws.eventbridge.model.Replay.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getReplays
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Replay.ReadOnly]] =
      AwsError.unwrapOptionField("replays", replays)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse
  ) extends zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly {
    override val replays
        : Optional[List[zio.aws.eventbridge.model.Replay.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replays())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Replay.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse
  ): zio.aws.eventbridge.model.ListReplaysResponse.ReadOnly = new Wrapper(impl)
}
