package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  DbUser,
  Database,
  RedshiftSecretManagerArn,
  Sql,
  StatementName
}
import scala.jdk.CollectionConverters.*
final case class RedshiftDataParameters(
    secretManagerArn: Optional[RedshiftSecretManagerArn] = Optional.Absent,
    database: Database,
    dbUser: Optional[DbUser] = Optional.Absent,
    sql: Sql,
    statementName: Optional[StatementName] = Optional.Absent,
    withEvent: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters = {
    import RedshiftDataParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
      .builder()
      .optionallyWith(
        secretManagerArn.map(value =>
          RedshiftSecretManagerArn.unwrap(value): java.lang.String
        )
      )(_.secretManagerArn)
      .database(Database.unwrap(database): java.lang.String)
      .optionallyWith(
        dbUser.map(value => DbUser.unwrap(value): java.lang.String)
      )(_.dbUser)
      .sql(Sql.unwrap(sql): java.lang.String)
      .optionallyWith(
        statementName.map(value =>
          StatementName.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(withEvent.map(value => value: java.lang.Boolean))(
        _.withEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly =
    zio.aws.eventbridge.model.RedshiftDataParameters.wrap(buildAwsValue())
}
object RedshiftDataParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RedshiftDataParameters =
      zio.aws.eventbridge.model.RedshiftDataParameters(
        secretManagerArn.map(value => value),
        database,
        dbUser.map(value => value),
        sql,
        statementName.map(value => value),
        withEvent.map(value => value)
      )
    def secretManagerArn: Optional[RedshiftSecretManagerArn]
    def database: Database
    def dbUser: Optional[DbUser]
    def sql: Sql
    def statementName: Optional[StatementName]
    def withEvent: Optional[Boolean]
    def getSecretManagerArn: ZIO[Any, AwsError, RedshiftSecretManagerArn] =
      AwsError.unwrapOptionField("secretManagerArn", secretManagerArn)
    def getDatabase: ZIO[Any, Nothing, Database] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, DbUser] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getSql: ZIO[Any, Nothing, Sql] = ZIO.succeed(sql)
    def getStatementName: ZIO[Any, AwsError, StatementName] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getWithEvent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withEvent", withEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ) extends zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly {
    override val secretManagerArn: Optional[RedshiftSecretManagerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretManagerArn())
        .map(value =>
          zio.aws.eventbridge.model.primitives.RedshiftSecretManagerArn(value)
        )
    override val database: Database =
      zio.aws.eventbridge.model.primitives.Database(impl.database())
    override val dbUser: Optional[DbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => zio.aws.eventbridge.model.primitives.DbUser(value))
    override val sql: Sql = zio.aws.eventbridge.model.primitives.Sql(impl.sql())
    override val statementName: Optional[StatementName] = zio.aws.core.internal
      .optionalFromNullable(impl.statementName())
      .map(value => zio.aws.eventbridge.model.primitives.StatementName(value))
    override val withEvent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.withEvent())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ): zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly = new Wrapper(
    impl
  )
}
