package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicationState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ReplicationState
}
object ReplicationState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ReplicationState
  ): zio.aws.eventbridge.model.ReplicationState = value match {
    case software.amazon.awssdk.services.eventbridge.model.ReplicationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplicationState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplicationState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplicationState =
      software.amazon.awssdk.services.eventbridge.model.ReplicationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.eventbridge.model.ReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplicationState =
      software.amazon.awssdk.services.eventbridge.model.ReplicationState.ENABLED
  }
  case object DISABLED extends zio.aws.eventbridge.model.ReplicationState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplicationState =
      software.amazon.awssdk.services.eventbridge.model.ReplicationState.DISABLED
  }
}
