package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RoutingConfig(
    failoverConfig: zio.aws.eventbridge.model.FailoverConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RoutingConfig = {
    import RoutingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RoutingConfig
      .builder()
      .failoverConfig(failoverConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RoutingConfig.ReadOnly =
    zio.aws.eventbridge.model.RoutingConfig.wrap(buildAwsValue())
}
object RoutingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RoutingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RoutingConfig =
      zio.aws.eventbridge.model.RoutingConfig(failoverConfig.asEditable)
    def failoverConfig: zio.aws.eventbridge.model.FailoverConfig.ReadOnly
    def getFailoverConfig
        : ZIO[Any, Nothing, zio.aws.eventbridge.model.FailoverConfig.ReadOnly] =
      ZIO.succeed(failoverConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RoutingConfig
  ) extends zio.aws.eventbridge.model.RoutingConfig.ReadOnly {
    override val failoverConfig
        : zio.aws.eventbridge.model.FailoverConfig.ReadOnly =
      zio.aws.eventbridge.model.FailoverConfig.wrap(impl.failoverConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RoutingConfig
  ): zio.aws.eventbridge.model.RoutingConfig.ReadOnly = new Wrapper(impl)
}
