package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SageMakerPipelineParameters(
    pipelineParameterList: Optional[
      Iterable[zio.aws.eventbridge.model.SageMakerPipelineParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameters = {
    import SageMakerPipelineParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameters
      .builder()
      .optionallyWith(
        pipelineParameterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameterList)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly =
    zio.aws.eventbridge.model.SageMakerPipelineParameters.wrap(buildAwsValue())
}
object SageMakerPipelineParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.SageMakerPipelineParameters =
      zio.aws.eventbridge.model.SageMakerPipelineParameters(
        pipelineParameterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineParameterList: Optional[
      List[zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly]
    ]
    def getPipelineParameterList: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("pipelineParameterList", pipelineParameterList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameters
  ) extends zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly {
    override val pipelineParameterList: Optional[
      List[zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineParameterList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.SageMakerPipelineParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameters
  ): zio.aws.eventbridge.model.SageMakerPipelineParameters.ReadOnly =
    new Wrapper(impl)
}
