package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventPattern
import scala.jdk.CollectionConverters.*
final case class TestEventPatternRequest(
    eventPattern: EventPattern,
    event: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest = {
    import TestEventPatternRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest
      .builder()
      .eventPattern(EventPattern.unwrap(eventPattern): java.lang.String)
      .event(event: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.TestEventPatternRequest.ReadOnly =
    zio.aws.eventbridge.model.TestEventPatternRequest.wrap(buildAwsValue())
}
object TestEventPatternRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.TestEventPatternRequest =
      zio.aws.eventbridge.model.TestEventPatternRequest(eventPattern, event)
    def eventPattern: EventPattern
    def event: String
    def getEventPattern: ZIO[Any, Nothing, EventPattern] =
      ZIO.succeed(eventPattern)
    def getEvent: ZIO[Any, Nothing, String] = ZIO.succeed(event)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest
  ) extends zio.aws.eventbridge.model.TestEventPatternRequest.ReadOnly {
    override val eventPattern: EventPattern =
      zio.aws.eventbridge.model.primitives.EventPattern(impl.eventPattern())
    override val event: String = impl.event(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest
  ): zio.aws.eventbridge.model.TestEventPatternRequest.ReadOnly = new Wrapper(
    impl
  )
}
