package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  HttpsEndpoint,
  ApiDestinationName,
  ConnectionArn,
  ApiDestinationDescription,
  ApiDestinationInvocationRateLimitPerSecond
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateApiDestinationRequest(
    name: ApiDestinationName,
    description: Optional[ApiDestinationDescription] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    invocationEndpoint: Optional[HttpsEndpoint] = Optional.Absent,
    httpMethod: Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod] =
      Optional.Absent,
    invocationRateLimitPerSecond: Optional[
      ApiDestinationInvocationRateLimitPerSecond
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest = {
    import UpdateApiDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest
      .builder()
      .name(ApiDestinationName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ApiDestinationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        invocationEndpoint.map(value =>
          HttpsEndpoint.unwrap(value): java.lang.String
        )
      )(_.invocationEndpoint)
      .optionallyWith(httpMethod.map(value => value.unwrap))(_.httpMethod)
      .optionallyWith(
        invocationRateLimitPerSecond.map(value =>
          ApiDestinationInvocationRateLimitPerSecond.unwrap(value): Integer
        )
      )(_.invocationRateLimitPerSecond)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateApiDestinationRequest.ReadOnly =
    zio.aws.eventbridge.model.UpdateApiDestinationRequest.wrap(buildAwsValue())
}
object UpdateApiDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.UpdateApiDestinationRequest =
      zio.aws.eventbridge.model.UpdateApiDestinationRequest(
        name,
        description.map(value => value),
        connectionArn.map(value => value),
        invocationEndpoint.map(value => value),
        httpMethod.map(value => value),
        invocationRateLimitPerSecond.map(value => value)
      )
    def name: ApiDestinationName
    def description: Optional[ApiDestinationDescription]
    def connectionArn: Optional[ConnectionArn]
    def invocationEndpoint: Optional[HttpsEndpoint]
    def httpMethod: Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod]
    def invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond]
    def getName: ZIO[Any, Nothing, ApiDestinationName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ApiDestinationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getInvocationEndpoint: ZIO[Any, AwsError, HttpsEndpoint] =
      AwsError.unwrapOptionField("invocationEndpoint", invocationEndpoint)
    def getHttpMethod: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ApiDestinationHttpMethod
    ] = AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getInvocationRateLimitPerSecond
        : ZIO[Any, AwsError, ApiDestinationInvocationRateLimitPerSecond] =
      AwsError.unwrapOptionField(
        "invocationRateLimitPerSecond",
        invocationRateLimitPerSecond
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest
  ) extends zio.aws.eventbridge.model.UpdateApiDestinationRequest.ReadOnly {
    override val name: ApiDestinationName =
      zio.aws.eventbridge.model.primitives.ApiDestinationName(impl.name())
    override val description: Optional[ApiDestinationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ApiDestinationDescription(value)
        )
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value => zio.aws.eventbridge.model.primitives.ConnectionArn(value))
    override val invocationEndpoint: Optional[HttpsEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationEndpoint())
        .map(value => zio.aws.eventbridge.model.primitives.HttpsEndpoint(value))
    override val httpMethod
        : Optional[zio.aws.eventbridge.model.ApiDestinationHttpMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMethod())
        .map(value =>
          zio.aws.eventbridge.model.ApiDestinationHttpMethod.wrap(value)
        )
    override val invocationRateLimitPerSecond
        : Optional[ApiDestinationInvocationRateLimitPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationRateLimitPerSecond())
        .map(value =>
          zio.aws.eventbridge.model.primitives
            .ApiDestinationInvocationRateLimitPerSecond(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest
  ): zio.aws.eventbridge.model.UpdateApiDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
