package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters.*
final case class UpdateConnectionOAuthClientRequestParameters(
    clientID: Optional[AuthHeaderParameters] = Optional.Absent,
    clientSecret: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthClientRequestParameters = {
    import UpdateConnectionOAuthClientRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
      .builder()
      .optionallyWith(
        clientID.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.clientID)
      .optionallyWith(
        clientSecret.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.clientSecret)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
      .wrap(buildAwsValue())
}
object UpdateConnectionOAuthClientRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters =
      zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters(
        clientID.map(value => value),
        clientSecret.map(value => value)
      )
    def clientID: Optional[AuthHeaderParameters]
    def clientSecret: Optional[AuthHeaderParameters]
    def getClientID: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("clientID", clientID)
    def getClientSecret: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
  ) extends zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly {
    override val clientID: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientID())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
    override val clientSecret: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSecret())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
  ): zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly =
    new Wrapper(impl)
}
